/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.liquid.ILiquidStack;
import net.dries007.tfc.api.capability.damage.CapabilityDamageResistance;
import net.dries007.tfc.api.capability.damage.DamageResistance;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodData;
import net.dries007.tfc.api.capability.food.FoodHandler;
import net.dries007.tfc.api.capability.forge.CapabilityForgeable;
import net.dries007.tfc.api.capability.forge.ForgeableHandler;
import net.dries007.tfc.api.capability.forge.ForgeableHeatableHandler;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.ItemHeatHandler;
import net.dries007.tfc.api.capability.metal.CapabilityMetalItem;
import net.dries007.tfc.api.capability.metal.MetalItemHandler;
import net.dries007.tfc.api.capability.size.CapabilityItemSize;
import net.dries007.tfc.api.capability.size.ItemSizeHandler;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.compat.crafttweaker.CTHelper;
import net.dries007.tfc.util.fuel.Fuel;
import net.dries007.tfc.util.fuel.FuelManager;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.terrafirmacraft.ItemRegistry")
@ZenRegister
public class CTItemRegistry {
    @ZenMethod
    public static void registerItemSize(final IIngredient input, String inputSize, String inputWeight) {
        if (input == null) {
            throw new IllegalArgumentException("Input not allowed to be empty!");
        }
        if (input instanceof ILiquidStack) {
            throw new IllegalArgumentException("There is a fluid where it's supposed to be an item!");
        }
        final net.dries007.tfc.objects.inventory.ingredient.IIngredient inputIngredient = CTHelper.getInternalIngredient(input);
        final Size size = Size.valueOf(inputSize.toUpperCase());
        final Weight weight = Weight.valueOf(inputWeight.toUpperCase());
        if (CapabilityItemSize.CUSTOM_ITEMS.get(inputIngredient) != null) {
            throw new IllegalStateException("Input registered more than once!");
        }
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                CapabilityItemSize.CUSTOM_ITEMS.put(inputIngredient, () -> ItemSizeHandler.get(size, weight, true));
            }

            public String describe() {
                return "Registered size and weight for " + input.toCommandString();
            }
        });
    }

    @ZenMethod
    public static void registerItemMetal(final IIngredient input, String metalStr, final int amount, final boolean canMelt) {
        if (input == null) {
            throw new IllegalArgumentException("Input not allowed to be empty!");
        }
        if (input instanceof ILiquidStack) {
            throw new IllegalArgumentException("There is a fluid where it's supposed to be an item!");
        }
        final Metal metal = TFCRegistries.METALS.getValuesCollection().stream().filter(x -> x.getRegistryName().func_110623_a().equalsIgnoreCase(metalStr)).findFirst().orElse(null);
        if (metal == null) {
            throw new IllegalArgumentException("Metal specified not found!");
        }
        final net.dries007.tfc.objects.inventory.ingredient.IIngredient inputIngredient = CTHelper.getInternalIngredient(input);
        if (CapabilityMetalItem.CUSTOM_METAL_ITEMS.get(inputIngredient) != null) {
            throw new IllegalStateException("Input already registered in metal item capability!");
        }
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                CapabilityMetalItem.CUSTOM_METAL_ITEMS.put(inputIngredient, () -> new MetalItemHandler(metal, amount, canMelt));
            }

            public String describe() {
                return "Registered metal item capability for " + input.toCommandString();
            }
        });
    }

    @ZenMethod
    public static void registerItemHeat(final IIngredient input, final float heatCapacity, final float meltTemp, final boolean forgeable) {
        if (input == null) {
            throw new IllegalArgumentException("Input not allowed to be empty!");
        }
        if (input instanceof ILiquidStack) {
            throw new IllegalArgumentException("There is a fluid where it's supposed to be an item!");
        }
        if (heatCapacity <= 0.0f || meltTemp <= 0.0f) {
            throw new IllegalArgumentException("Heat capacity and melt temp must be higher than 0!");
        }
        final net.dries007.tfc.objects.inventory.ingredient.IIngredient inputIngredient = CTHelper.getInternalIngredient(input);
        if (CapabilityItemHeat.CUSTOM_ITEMS.get(inputIngredient) != null || CapabilityForgeable.CUSTOM_ITEMS.get(inputIngredient) != null) {
            throw new IllegalStateException("Input already registered in forge/heat capability!");
        }
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                if (forgeable) {
                    CapabilityForgeable.CUSTOM_ITEMS.put(inputIngredient, () -> new ForgeableHeatableHandler(null, heatCapacity, meltTemp));
                } else {
                    CapabilityItemHeat.CUSTOM_ITEMS.put(inputIngredient, () -> new ItemHeatHandler(null, heatCapacity, meltTemp));
                }
            }

            public String describe() {
                return "Registered heat capacity for " + input.toCommandString();
            }
        });
    }

    @ZenMethod
    public static void registerItemForgeable(final IIngredient input) {
        if (input == null) {
            throw new IllegalArgumentException("Input not allowed to be empty!");
        }
        if (input instanceof ILiquidStack) {
            throw new IllegalArgumentException("There is a fluid where it's supposed to be an item!");
        }
        final net.dries007.tfc.objects.inventory.ingredient.IIngredient inputIngredient = CTHelper.getInternalIngredient(input);
        if (CapabilityItemHeat.CUSTOM_ITEMS.get(inputIngredient) != null || CapabilityForgeable.CUSTOM_ITEMS.get(inputIngredient) != null) {
            throw new IllegalStateException("Input already registered in forge/heat capability!");
        }
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                CapabilityForgeable.CUSTOM_ITEMS.put(inputIngredient, () -> new ForgeableHandler(null));
            }

            public String describe() {
                return "Registered forgeable capability for " + input.toCommandString();
            }
        });
    }

    @ZenMethod
    public static void registerFood(final IIngredient input, final int hunger, final float water, final float saturation, final float decay, final float grain, final float veg, final float fruit, final float protein, final float dairy) {
        if (input == null) {
            throw new IllegalArgumentException("Input not allowed to be empty!");
        }
        if (input instanceof ILiquidStack) {
            throw new IllegalArgumentException("There is a fluid where it's supposed to be an item!");
        }
        final net.dries007.tfc.objects.inventory.ingredient.IIngredient inputIngredient = CTHelper.getInternalIngredient(input);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                CapabilityFood.CUSTOM_FOODS.put(inputIngredient, () -> new FoodHandler(null, new FoodData(hunger, water, saturation, grain, fruit, veg, protein, dairy, decay)));
            }

            public String describe() {
                return "Registered food stats for " + input.toCommandString();
            }
        });
    }

    @ZenMethod
    public static void registerArmor(final IIngredient input, final float crushingModifier, final float piercingModifier, final float slashingModifier) {
        if (input == null) {
            throw new IllegalArgumentException("Input not allowed to be empty!");
        }
        if (input instanceof ILiquidStack) {
            throw new IllegalArgumentException("There is a fluid where it's supposed to be an item!");
        }
        final net.dries007.tfc.objects.inventory.ingredient.IIngredient inputIngredient = CTHelper.getInternalIngredient(input);
        if (CapabilityDamageResistance.CUSTOM_ARMOR.get(inputIngredient) != null) {
            throw new IllegalStateException("Armor registered more than once!");
        }
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                CapabilityDamageResistance.CUSTOM_ARMOR.put(inputIngredient, () -> new DamageResistance(crushingModifier, piercingModifier, slashingModifier));
            }

            public String describe() {
                return "Registered armor stats for " + input.toCommandString();
            }
        });
    }

    @ZenMethod
    public static void registerFuel(IIngredient itemInput, int burnTicks, float temperature, boolean forgeFuel, boolean bloomeryFuel) {
        if (itemInput == null) {
            throw new IllegalArgumentException("Item not allowed to be empty!");
        }
        if (itemInput instanceof ILiquidStack) {
            throw new IllegalArgumentException("There is a fluid where it's supposed to be an item!");
        }
        if (burnTicks <= 0 || temperature <= 0.0f) {
            throw new IllegalArgumentException("Temp and burn ticks must be higher than 0!");
        }
        net.dries007.tfc.objects.inventory.ingredient.IIngredient ing = CTHelper.getInternalIngredient(itemInput);
        final Fuel fuel = new Fuel(ing, burnTicks, temperature, forgeFuel, bloomeryFuel);
        if (!FuelManager.canRegister(fuel)) {
            throw new IllegalStateException("Fuel already registered!");
        }
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                FuelManager.addFuel(fuel);
            }

            public String describe() {
                return "Registered fuel stats";
            }
        });
    }
}

